/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.generator;

import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5284;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.betterx.bclib.BCLib;
import org.betterx.bclib.api.v2.levelgen.biomes.InternalBiomeAPI;
import org.betterx.worlds.together.biomesource.BiomeSourceFromRegistry;
import org.betterx.worlds.together.biomesource.BiomeSourceHelper;
import org.betterx.worlds.together.biomesource.MergeableBiomeSource;
import org.betterx.worlds.together.world.BiomeSourceWithNoiseRelatedSettings;
import org.betterx.worlds.together.world.BiomeSourceWithSeed;
import org.jetbrains.annotations.NotNull;

public abstract class BCLBiomeSource
extends class_1966
implements BiomeSourceWithSeed,
MergeableBiomeSource<BCLBiomeSource>,
BiomeSourceWithNoiseRelatedSettings,
BiomeSourceFromRegistry<BCLBiomeSource> {
    protected final class_2378<class_1959> biomeRegistry;
    private int registryModificationCounter;
    protected long currentSeed;
    protected int maxHeight;

    private static List<class_6880<class_1959>> preInit(class_2378<class_1959> biomeRegistry, List<class_6880<class_1959>> biomes) {
        biomes = biomes.stream().sorted(Comparator.comparing(holder -> ((class_5321)holder.method_40230().get()).method_29177().toString())).toList();
        return biomes;
    }

    protected BCLBiomeSource(class_2378<class_1959> biomeRegistry, List<class_6880<class_1959>> list, long seed) {
        super(BCLBiomeSource.preInit(biomeRegistry, list));
        this.registryModificationCounter = InternalBiomeAPI.getBiomeRegistryModificationCount(biomeRegistry);
        this.biomeRegistry = biomeRegistry;
        this.currentSeed = seed;
    }

    @Override
    public boolean didBiomeRegistryChange() {
        return this.registryModificationCounter != InternalBiomeAPI.getBiomeRegistryModificationCount(this.biomeRegistry);
    }

    @Override
    public final void setSeed(long seed) {
        if (seed != this.currentSeed) {
            BCLib.LOGGER.debug(this + "\n    --> new seed = " + seed);
            this.currentSeed = seed;
            this.initMap(seed);
        }
    }

    public final void setMaxHeight(int maxHeight) {
        if (this.maxHeight != maxHeight) {
            BCLib.LOGGER.debug(this + "\n    --> new height = " + maxHeight);
            this.maxHeight = maxHeight;
            this.onHeightChange(maxHeight);
        }
    }

    protected final void initMap(long seed) {
        BCLib.LOGGER.debug(this + "\n    --> Map Update");
        this.onInitMap(seed);
    }

    protected abstract void onInitMap(long var1);

    protected abstract void onHeightChange(int var1);

    public BCLBiomeSource createCopyForDatapack(Set<class_6880<class_1959>> datapackBiomes) {
        HashSet mutableSet = Sets.newHashSet();
        mutableSet.addAll(datapackBiomes);
        return this.cloneForDatapack(mutableSet);
    }

    protected abstract BCLBiomeSource cloneForDatapack(Set<class_6880<class_1959>> var1);

    @NotNull
    protected String getNamespaces() {
        return BiomeSourceHelper.getNamespaces(this.method_28443());
    }

    protected static List<class_6880<class_1959>> getBiomes(class_2378<class_1959> biomeRegistry, List<String> exclude, List<String> include, ValidBiomePredicate test) {
        return biomeRegistry.method_10220().filter(biome -> biomeRegistry.method_29113(biome).isPresent()).map(biome -> biomeRegistry.method_44298((class_5321)biomeRegistry.method_29113(biome).get())).filter(biome -> {
            class_2960 location = ((class_5321)biome.method_40230().orElseThrow()).method_29177();
            String strLocation = location.toString();
            if (exclude.contains(strLocation)) {
                return false;
            }
            if (include.contains(strLocation)) {
                return true;
            }
            return test.isValid((class_6880<class_1959>)biome, location);
        }).toList();
    }

    @Override
    public BCLBiomeSource mergeWithBiomeSource(class_1966 inputBiomeSource) {
        Set datapackBiomes = inputBiomeSource.method_28443();
        return this.createCopyForDatapack(datapackBiomes);
    }

    @Override
    public void onLoadGeneratorSettings(class_5284 generator) {
        this.setMaxHeight(generator.comp_474().comp_174());
    }

    @Override
    public class_2378<class_1959> getBiomeRegistry() {
        return this.biomeRegistry;
    }

    public static interface ValidBiomePredicate {
        public boolean isValid(class_6880<class_1959> var1, class_2960 var2);
    }
}

